/* ============ */
/* setkosm.c	*/
/* ============ */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>
#include <freqdefs.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	NEED_ALL(Label)	"\nEnter Number of "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	SAMPLES_LABEL	"Samples Per K-S Run"
#define	KS_RUNS_LABEL	"K-S Runs For KS-on-KS Calculation"

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetKoSmControls - Sets Run Controls for Kolmogorov-Smirnov test	*/
/* ==================================================================== */
void
SetKoSmControls(KS_DATA_STRU *KSData)
{
    int     NewlineCh;
    int     UserIntEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* --------------------------------- */
    /* Get Number of Samples Per K-S Run */
    /* --------------------------------- */
    fflush(NULL);
    GetInt(NEED_USER_ENTRY(SAMPLES_LABEL, MIN_KS_SAMPS, MAX_KS_SAMPS),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, SAMPLES_LABEL);

    CLAMP(KSData->SampleSize, UserIntEntry, MIN_KS_SAMPS, MAX_KS_SAMPS);

    SHOW_INT_VALUE_USED(UserIntEntry, KSData->SampleSize);

    /* ------------------------------------------- */
    /* Get Number of KS Runs for KS-on-KS Analysis */
    /* ------------------------------------------- */
    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    GetInt(NEED_USER_ENTRY(KS_RUNS_LABEL, MIN_KS_RUNS, MAX_KS_RUNS),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, KS_RUNS_LABEL);

    CLAMP(KSData->NumKSRuns, UserIntEntry, MIN_KS_RUNS, MAX_KS_RUNS);

    SHOW_INT_VALUE_USED(UserIntEntry, KSData->NumKSRuns);
}
